#!/bin/sh
#set -xv
UPGRADE_VER="0.0.11"
BIN_PATH="/home/root"
CARD_PATH=${MOUNTR}
UPGRADE_MD5="upgrade.md5"
UPGRADE_SH="Upgrade.sh"
KERN_NAME="uImage-bp4"
BOOT_NAME="u-boot.imx"
RTFS_NAME="bp4_rootfs"
NWRITE_NAME="nwrite"
NAND_WR=${CARD_PATH}/${NWRITE_NAME}
WARTOOL="checkWar"
PROD_NAME="productVersion.txt"
SH_LOG=/tmp/sh.log

# NAND
BOOT_DD_DEV=/dev/mtdblock1
KERN_DD_DEV=/dev/mtdblock4
RTFS_DD_DEV=/dev/mtdblock5
RESC_DD_DEV=/dev/mtdblock7
RESC_BOOT_OFS=0x400000
RESC_KERN_OFS=0x800000
RESC_RTFS_OFS=0x1800000
DIAG_DD_DEV=/dev/mtdblock8

# PMU
PMU_FW_NAME=SP6_PMU.bin
PMU_LOADER_NAME=pmu_loader
PMU_DEB_LOG=pmu_deb.log

displ() {
 ${PRINTTOOL} --x=20 --y=4  --text="Upgrading" --clear
 ${PRINTTOOL} --x=20 --y=24 --text="Firmware"
 ${PRINTTOOL} --x=20 --y=44 --text="${1}"
 echo "Upgrading ${1}" | tee -a ${LOG}
}

do_reboot() {
#  if [ -f ${CARD_PATH}/upl_start.log ]; then
    echo "Removing temporary files from ${CARD_PATH}" | tee -a ${LOG}
    rm -f ${CARD_PATH}/${RTFS_NAME}* ${CARD_PATH}/${KERN_NAME}* ${CARD_PATH}/${BOOT_NAME}* ${CARD_PATH}/upl_start.log
    rm -f ${CARD_PATH}/${UPGRADE_MD5} ${CARD_PATH}/${NWRITE_NAME} ${CARD_PATH}/${PROD_NAME}
    rm -f ${CARD_PATH}/*.ta_
    rm -f ${CARD_PATH}/${UPGRADE_SH}
    rm -f ${CARD_PATH}/${PMU_FW_NAME} 
    rm -f ${CARD_PATH}/${PMU_LOADER_NAME}
#  fi
  echo "Message:${2}" | tee -a ${LOG}
  displ ${2}
  # !The next should be the lats message in uploading.log!
  echo "Exit code is ${1}" | tee -a ${LOG}
  reboot
  sleep 300
}

do_file_check() {
 echo "[$(cat /proc/uptime | cut -d ' ' -f1)] Check file ${1}" | tee -a ${LOG}
 hash1=`grep ${1} ${UPGRADE_MD5} | awk '{split($0,x," ");printf("%s",x[1])}'`
 echo "Orig hash $hash1" | tee -a ${LOG}
 hash2=$(md5sum ${1} | awk '{split($0,x," ");printf("%s",x[1])}')
 echo "File hash $hash2" | tee -a ${LOG}
 if [ "${hash1}" != "${hash2}" ]; then
  echo "${1} read failure" | tee -a ${LOG}
  echo "SMOD 0" > /proc/sp4
  echo "UCMD STRT" > /proc/sp4
  echo "UERR 1" > /proc/sp4
  do_reboot -1 "Error 3"
 fi
}

do_sys_check() {
 chk_name=${CARD_PATH}/${1}
 chk_len=$(ls -l $chk_name | awk '{split($0,x," ");printf("%s",x[5])}')
 dd_len=$(($chk_len/512+1))
 chk_hash="n/a"
 $NAND_WR -d ${3} -o $2 -r ${chk_name}.out ${chk_len} | tee -a ${LOG}
 if [ $? -eq 0 ]; then
  chk_hash=`cat ${chk_name}.out | md5sum | awk '{split($0,x," ");printf("%s",x[1])}'`
 else
  echo "$NAND_WR read error" | tee -a ${LOG}
  chk_hash="n/a"  
 fi
 orig_hash=`grep ${1} ${CARD_PATH}/${UPGRADE_MD5} | awk '{split($0,x," ");printf("%s",x[1])}'`
 echo "[$(cat /proc/uptime | cut -d ' ' -f1)] chk_name $chk_name chk_len $chk_len dd_len $dd_len skip $2" | tee -a ${LOG}
 echo "chk_hash  $chk_hash" | tee -a ${LOG}
 echo "orig_hash $orig_hash" | tee -a ${LOG}
 if [ "${chk_hash}" != "${orig_hash}" ]; then
  echo "[$(cat /proc/uptime | cut -d ' ' -f1)] ${1} md5sum differ" | tee -a ${LOG}
  ret=1
 else 
  echo "[$(cat /proc/uptime | cut -d ' ' -f1)] ${1} md5sum Ok" | tee -a ${LOG}
  ret=0
 fi
}

do_sys_write() {
 # Img.Name, Offs, Dev.Name
 /usr/local/bin/wd_ping -1 > /dev/null
 do_sys_check $1 $2 $3
 if [ $ret -ne 0 ]; then
  echo "[$(cat /proc/uptime | cut -d ' ' -f1)] wr img:${1} to dev:${3} offs:${2}" | tee -a ${LOG}
  $NAND_WR -d ${3} -o ${2} -i ${CARD_PATH}/${1} | tee -a ${LOG}
  if [ $? -ne 0 ]; then
	echo "[$(cat /proc/uptime | cut -d ' ' -f1)] ${1} record failure" | tee -a ${LOG}
	ret=1
  else
    echo "[$(cat /proc/uptime | cut -d ' ' -f1)] img:${1} on dev:${3} offs:${2} write Ok" | tee -a ${LOG}
    ret=0
  fi
 else
  echo "[$(cat /proc/uptime | cut -d ' ' -f1)] img:${1} on dev:${3} offs:${2} is the same. Write skipped" | tee -a ${LOG}
 fi
}

# start from here
cd ${CARD_PATH}
rm -f ${LOG}
echo "[$(cat /proc/uptime | cut -d ' ' -f1)] Starting upgrade script ${UPGRADE_VER} at " $(date) "smod=$smod" | tee -a ${LOG}
echo "---${SH_LOG} begin" | tee -a ${LOG}
cat ${SH_LOG} | tee -a ${LOG}
echo "---${SH_LOG} end" | tee -a ${LOG}
ps | grep wd_ping | awk '{split($0,x," ");printf("%s ",x[1])}' | xargs kill
sleep 1
/usr/local/bin/wd_ping -30 -p | tee -a ${LOG} &
ret=$?
echo "wd_ping ret $ret" | tee -a ${LOG}
if [ $ret -ne 0 ]; then
/usr/local/bin/wd_ping -30 -p | tee -a ${LOG} &
fi
uname -a | tee -a ${LOG}
mount | tee -a ${LOG}
ps | grep wd_ping | tee -a ${LOG}
df | tee -a ${LOG}
if [ -f ${BIN_PATH}/${PROD_NAME} ]; then
   echo "Previous product version " $(cat ${BIN_PATH}/${PROD_NAME}) | tee -a ${LOG}
fi

# Check Warr
pwd | tee -a ${LOG}
tar -x${TAR_OPT} ${TAR_FILE} ${PROD_NAME}
ls -l * | tee -a ${LOG}

if [ ! "$(cat ${BIN_PATH}/${PROD_NAME} | awk '{split($0,x,"_");printf("%s ",x[2])}')" == "rescue" ]; then
 WAR_FILE=${BIN_PATH}/${WARTOOL}
 if [ -f ${WAR_FILE} ]; then
 echo "Checking Warr at " $(date) | tee -a ${LOG}
 ${WAR_FILE} ./${PROD_NAME}
 if [ $? -eq 0 ]; then
  echo "Error to upgrade. Warranty period exceeds !!!" | tee -a ${LOG}
  echo "Ending upgrade script at " $(date) | tee -a ${LOG}
  echo "SMOD 0" > /proc/sp4
  echo "UCMD STRT" > /proc/sp4
  echo "UERR 1" > /proc/sp4
  do_reboot -1 "Not Allowed"
 fi
fi
else
 echo "Rescue mode. Skip Warr"
fi

fl_kupl=0
flist="`tar -t$TAR_OPT $TAR_FILE`"
echo "flist:$flist" | tee -a ${LOG}
fl_rfs=`echo $flist | grep -c "$RTFS_NAME"`
fl_kern=`echo $flist | grep -c "$KERN_NAME"`
fl_boot=`echo $flist | grep -c "$BOOT_NAME"`
echo "fl_rfs=$fl_rfs, fl_kern=$fl_kern, fl_boot=$fl_boot" | tee -a ${LOG}
if [[ "${fl_rfs}" -ne "0" && "${fl_kern}" -ne "0" && "${fl_boot}" -ne "0" ]]; then
     fl_kupl=1
     tar -x$TAR_OPT $TAR_FILE $UPGRADE_MD5
     if [ ! -f ${UPGRADE_MD5} ]; then
        echo "Can not find $UPGRADE_MD5. Upgrade cancelled" | tee -a ${LOG}
        echo "SMOD 0" > /proc/sp4
        echo "UCMD STRT" > /proc/sp4
        echo "UERR 1" > /proc/sp4
        do_reboot -1 "Error 1.1"
     fi
     tar -x$TAR_OPT $TAR_FILE $NWRITE_NAME
     if [ ! -f ${NWRITE_NAME} ]; then
        echo "Can not find $NWRITE_NAME. Upgrade cancelled" | tee -a ${LOG}
        echo "SMOD 0" > /proc/sp4
        echo "UCMD STRT" > /proc/sp4
        echo "UERR 1" > /proc/sp4
        do_reboot -1 "Error 1.2"
     fi
     do_file_check ${NWRITE_NAME}
     echo "Upgrade BSP" > ${CARD_PATH}/upl_start.log
     if [ ! -f ${CARD_PATH}/upl_start.log ]; then
         echo "Readonly" | tee -a ${LOG}
         echo "SMOD 0" > /proc/sp4
         echo "UCMD STRT" > /proc/sp4
         echo "UERR 1" > /proc/sp4
         do_reboot -1 "Error 1.3"
     fi
fi
# RFS
displ "Step 1/5"

if [ ! "$fl_rfs" -eq "0" ]; then
     echo "[$(cat /proc/uptime | cut -d ' ' -f1)] unpack $RTFS_NAME to ${CARD_PATH}" | tee -a ${LOG}
     tar -x$TAR_OPT $TAR_FILE $RTFS_NAME
     ret=$?
     echo "Unpack ret $ret" | tee -a ${LOG}
     do_file_check ${RTFS_NAME}
fi
# KERN
if [ ! "$fl_kern" -eq "0" ]; then
     echo "[$(cat /proc/uptime | cut -d ' ' -f1)] unpack $KERN_NAME to ${CARD_PATH}" | tee -a ${LOG}
     tar -x$TAR_OPT $TAR_FILE $KERN_NAME
     ret=$?
     echo "Unpack ret $ret" | tee -a ${LOG}
     do_file_check ${KERN_NAME}
fi
# BOOT
if [ ! "$fl_boot" -eq "0" ]; then
     echo "[$(cat /proc/uptime | cut -d ' ' -f1)] unpack $BOOT_NAME to ${CARD_PATH}" | tee -a ${LOG}
     tar -x$TAR_OPT $TAR_FILE $BOOT_NAME | tar -xj
     ret=$?
     echo "Unpack ret $ret" | tee -a ${LOG}
     do_file_check ${BOOT_NAME}
fi

if [ "${fl_kupl}" -ne "1" ]; then
  do_reboot -1 "Update skipped. Exiting"
fi

displ "Step 2/5"

# Resc
echo "[$(cat /proc/uptime | cut -d ' ' -f1)] Write rescue" | tee -a ${LOG}
do_sys_write ${BOOT_NAME} $RESC_BOOT_OFS $RESC_DD_DEV
echo "[$(cat /proc/uptime | cut -d ' ' -f1)] ret $ret" | tee -a ${LOG}
do_sys_write ${KERN_NAME} $RESC_KERN_OFS $RESC_DD_DEV
echo "[$(cat /proc/uptime | cut -d ' ' -f1)] ret $ret" | tee -a ${LOG}
do_sys_write ${RTFS_NAME} $RESC_RTFS_OFS $RESC_DD_DEV
echo "[$(cat /proc/uptime | cut -d ' ' -f1)] ret $ret" | tee -a ${LOG}

displ "Step 3/5"

# Main
echo "Write main" | tee -a ${LOG}
do_sys_write ${BOOT_NAME} 0 $BOOT_DD_DEV
echo "ret $ret" | tee -a ${LOG}
do_sys_write ${KERN_NAME} 0 $KERN_DD_DEV
echo "ret $ret" | tee -a ${LOG}
do_sys_write ${RTFS_NAME} 0 $RTFS_DD_DEV
echo "ret $ret" | tee -a ${LOG}

if [ "$fl_kupl" -eq "1" ]; then
     echo "UCMD KUPL" > /proc/sp4
     # The next line fills environment with 0xFF
     # tr "\000" "\377" < /dev/zero | dd count=1024 of=/dev/mtdblock1
     echo "Boot env. reset at /dev/mtd2" | tee -a ${LOG}
     # flash_erase dev_name start_offset block_cnt
     flash_erase /dev/mtd2 0 1 | tee -a ${LOG}
fi

# PMU upgrade
if [ `grep -c ${PMU_FW_NAME} ${UPGRADE_MD5}` -eq 1 ]; then

  displ "Step 4/5"

  cd ${CARD_PATH}
  echo "[$(cat /proc/uptime | cut -d ' ' -f1)] unpack ${PMU_FW_NAME} to ${CARD_PATH}" | tee -a ${LOG}
  tar -x$TAR_OPT $TAR_FILE ${PMU_FW_NAME} ${PMU_LOADER_NAME}
  ret=$?
  echo "Unpack ret $ret" | tee -a ${LOG}

  do_file_check ${PMU_FW_NAME}
  do_file_check ${PMU_LOADER_NAME}

  echo "[$(cat /proc/uptime | cut -d ' ' -f1)] Upgrading PMU at " $(date) | tee -a  ${LOG}

  /usr/local/bin/pmu_cmds -v
  if [ $? -eq 0 ]; then
   pmu_ver1=`/usr/local/bin/pmu_cmds -v | awk '{split($0,x,"."); printf("%s",substr(x[1],length(x[1])));}' | hexdump -n 1 -v -e '"%02x"'`
   pmu_ver2=`/usr/local/bin/pmu_cmds -v | awk '{split($0,x,"."); printf("%s",x[2]);}' | hexdump -n 1 -v -e '"%02x"'`
  else
   pmu_ver1="??";
   pmu_ver2="??";
  fi

   f_ver1=`tail -c 8 ${PMU_FW_NAME} | hexdump -v -n 1 -e '"%02x"'`
   f_ver2=`tail -c 7 ${PMU_FW_NAME} | hexdump -v -n 1 -e '"%02x"'`

   echo "pmu_ver:${pmu_ver1}${pmu_ver2},f_ver:${f_ver1}${f_ver2}" | tee -a  ${LOG}
   if [ "${pmu_ver1}${pmu_ver2}" != "${f_ver1}${f_ver2}" ]; then
     echo "starting:./${PMU_LOADER_NAME} -f ${PMU_FW_NAME}" | tee -a ${LOG}
     ./${PMU_LOADER_NAME} -f ${PMU_FW_NAME} -p /dev/spidev0.0 -r 146 -i
     if [ ! $? -eq 0 ]; then
       # not inversed PMU RST attempt
       echo "not inversed PMU RST attempt" | tee -a  ${LOG}
       ./${PMU_LOADER_NAME} -f ${PMU_FW_NAME} -p /dev/spidev0.0 -r 146
     fi
     if [ ! $? -eq 0 ]; then
       echo "Error to upgrade PMU !!!" | tee -a  ${LOG}
       cat ${PMU_DEB_LOG} | tee -a  ${LOG}
       echo "Ending upgrade script at " $(date) | tee -a ${LOG}
       do_reboot -1 "Error 5.1"
     fi
   else
       echo "PMU upgrade skip." | tee -a  ${LOG}
   fi
   rm -rf ${PMU_DEB_LOG}
fi

displ "Step 5/5"

echo "[$(cat /proc/uptime | cut -d ' ' -f1)] Removing prev.data" | tee -a ${LOG}
rm -rf /mnt/pvt/reg* /mnt/pvt/antenna/
cd /mnt/bin
rm -f CHAN PVT SL sp4*.sh bt_iap pvt_storage.txt productVersion.txt *PMU.bin
rm -rf www
sync
echo "[$(cat /proc/uptime | cut -d ' ' -f1)] Removing prev.data complete" | tee -a ${LOG}

echo "SMOD 0" > /proc/sp4
echo "UCMD STRT" > /proc/sp4
do_reboot 0 "Complete"
