#!/bin/sh
#set -xv
UPGRADE_VER="1.0.11"
TARGET_PREFIX=sp80_upgrade_
BIN_PATH=/home/root
CARD_PATH=${MOUNTR}
RAM_PATH=/mnt/ram
# PMU
PMU_TAR=${TARGET_PREFIX}pmu.bz2
PMU_FW_NAME=SP8_PMU.BIN
PMU_LOADER_NAME=pmu_loader
# GNSS
GNSS_TAR=${TARGET_PREFIX}gnss.bz2
G5_SENSOR_NAME=GNSS_FW.BIN
SP4_LOADER_NAME=sp4loader
CPU1_BOOT_NAME=u-boot.bin.cpu1
CPU1_XLDR_NAME=x-load.bin.ift.cpu1
CRC32_NAME=crc32
# CPU2 APPL
APPL_TAR=${TARGET_PREFIX}appl.bz2
PVT_NAME=PVT
PVT_STORAGE_NAME=pvt_storage.txt
SERVICE_LAYER_NAME=SL
SERVICE_MODE_NAME=serviceMode
PROCESS_LAUNCHER_NAME=processLauncher
# CPU2 BSP
SYSUPD_TAR=sys_upd.bz2
KERN_TAR=${TARGET_PREFIX}kern.bz2
KERN_NAME=uImage-sp4
BOOT_TAR=${TARGET_PREFIX}boot.bz2
BOOT_NAME=u-boot.bin
XLDR_NAME=x-load.bin.ift.cpu2
RFS_TAR=${TARGET_PREFIX}rfs.bz2
RFS_NAME=sp4_rootfs
NWRITE_NAME=nwrite
NAND_WR=${RAM_PATH}/${NWRITE_NAME}
# NAND STORAGE
OUT_DD_DEV=/dev/mtdblock5
OUT_CHAR_DEV=/dev/mtd5
BOOT_DD_DEV=/dev/mtdblock0
BOOT_CHAR_DEV=/dev/mtd0

# WARRANTY
WARTOOL=checkWar

displ() {
${PRINTTOOL} --x=20 --y=4  --text="Upgrading" --clear
${PRINTTOOL} --x=20 --y=24 --text="Firmware"
${PRINTTOOL} --x=20 --y=44 --text="${1}"
echo "Upgrading ${1}" | tee -a ${LOG}
}

do_reboot() {
  if [ -f ${CARD_PATH}/upl_start.log ]; then
    rm -rf ${CARD_PATH}/${RFS_NAME}* ${CARD_PATH}/${KERN_NAME}* ${CARD_PATH}/${BOOT_NAME}* ${CARD_PATH}/upl_start.log
    rm -rf ${CARD_PATH}/${XLDR_NAME}*
  fi
  displ ${2}
  echo "Rebooting" | tee -a ${LOG}
  reboot
  sleep 300
}

do_sys_check() {
 chk_name=${CARD_PATH}/${1}
 chk_len=$(ls -l $chk_name | awk '{split($0,x," ");printf("%s",x[5])}')
 dd_len=$(($chk_len/512+1))
 chk_hash="n/a"
 #chk_hash=`dd if=$OUT_DD_DEV skip=$2 count=$dd_len | head -c $chk_len | md5sum | awk '{split($0,x," ");printf("%s",x[1])}'`
 $NAND_WR -d ${OUT_DD_DEV} -o $2 -r ${chk_name}.out ${chk_len} | tee -a ${LOG}
 if [ $? -eq 0 ]; then
  chk_hash=`cat ${chk_name}.out | md5sum | awk '{split($0,x," ");printf("%s",x[1])}'`
 fi
 orig_hash=`cat $chk_name.md5 | awk '{split($0,x," ");printf("%s",x[1])}'`
 echo "chk_name $chk_name chk_len $chk_len dd_len $dd_len skip $2" | tee -a ${LOG}
 echo "chk_hash  $chk_hash" | tee -a ${LOG}
 echo "orig_hash $orig_hash" | tee -a ${LOG}

 if [ "${chk_hash}" != "${orig_hash}" ]; then
  echo "$1 md5sum error" | tee -a ${LOG}
  echo "Ending upgrade script at " $(date) | tee -a ${LOG}
  echo "UERR 1" > /proc/sp4
  flash_erase ${OUT_CHAR_DEV} $2 | tee -a ${LOG}
  do_reboot 1 "Error 1.5"
 else 
  echo "$1 md5sum Ok" | tee -a ${LOG}
 fi
}

copy_app() {

if [ -f ${1} ];
then
	echo "Upgrading $1 at " $(date) | tee -a ${LOG}
	cp -f ${1} ${BIN_PATH}/${1} >> ${LOG} 2>&1
	if [ ! $? -eq 0 ];
	then
		echo "Error to upgrade ${1} !!!" | tee -a ${LOG}
		echo "Ending upgrade script at " $(date) | tee -a ${LOG}
        echo "UERR 1" > /proc/sp4
        # Force U-Boot restoration 
        echo "UCNT 4" > /proc/sp4
        do_reboot 1 "Error 6"
	fi
	chmod 777 ${BIN_PATH}/${1}
    hash1=$(grep ${1} appl.md5 | awk '{split($0,x," ");printf("%s",x[1])}')
    echo "Orig hash $hash1" | tee -a ${LOG}
    hash2=$(md5sum ${BIN_PATH}/${1} | awk '{split($0,x," ");printf("%s",x[1])}')
    echo "File hash $hash2" | tee -a ${LOG}
    if [ "${hash1}" != "${hash2}" ]; then
        echo "Md5sum error" | tee -a ${LOG}
        echo "UERR 1" > /proc/sp4
        # Force U-Boot restoration 
        echo "UCNT 4" > /proc/sp4
        do_reboot 1 "Error 6"
    fi
fi

}

check_gnss() {
if [ -f ${1} ]; then
	echo "Check $1 at " $(date) | tee -a ${LOG}
    hash1=$(grep ${1} gnss.md5 | awk '{split($0,x," ");printf("%s",x[1])}')
    echo "Orig hash $hash1" | tee -a ${LOG}
    hash2=$(md5sum ${1} | awk '{split($0,x," ");printf("%s",x[1])}')
    echo "File hash $hash2" | tee -a ${LOG}
    if [ "${hash1}" != "${hash2}" ]; then
        echo "Md5sum error" | tee -a ${LOG}
        echo "UERR 1" > /proc/sp4
        do_reboot 1 "Error 7.8"
    fi
else
        echo "Not found $1" | tee -a ${LOG}
        echo "UERR 1" > /proc/sp4
        do_reboot 1 "Error 7.9"
fi
}

check_pmu() {
if [ -f ${1} ]; then
	echo "Check $1 at " $(date) | tee -a ${LOG}
    hash1=$(grep ${1} pmu.md5 | awk '{split($0,x," ");printf("%s",x[1])}')
    echo "Orig hash $hash1" | tee -a ${LOG}
    hash2=$(md5sum ${1} | awk '{split($0,x," ");printf("%s",x[1])}')
    echo "File hash $hash2" | tee -a ${LOG}
    if [ "${hash1}" != "${hash2}" ]; then
        echo "Md5sum error" | tee -a ${LOG}
        echo "UERR 1" > /proc/sp4
        do_reboot 1 "Error 9"
    fi
else
        echo "Not found $1" | tee -a ${LOG}
        echo "UERR 1" > /proc/sp4
        do_reboot 1 "Error 9.1"
fi
}

if [ -e "/dev/mtd10" ]; then 
    OUT_DD_DEV=/dev/mtdblock6
    OUT_CHAR_DEV=/dev/mtd6
fi

fl_continue=0
if [ "$smod" -eq "4" ]; then fl_continue=1 ; fi
if [ "$smod" -eq "14" ]; then fl_continue=1 ; fi

if [ "$fl_continue" -eq "0" ];
then
    rm -rf ${LOG}
    echo "Starting upgrade script ${UPGRADE_VER} at " $(date) "smod=$smod" | tee -a ${LOG}
    uname -a | tee -a ${LOG}
    mount | tee -a ${LOG}
    df | tee -a ${LOG}
    if [ -f ${BIN_PATH}/productVersion.txt ]; then
       echo "Previous product version " $(cat ${BIN_PATH}/productVersion.txt) | tee -a ${LOG}
    fi

#
# Check warranty period
#
pwd | tee -a ${LOG}
tar -x${TAR_OPT} ${TAR_FILE} productVersion.txt
ls -l | tee -a ${LOG}
WAR_FILE=${BIN_PATH}/${WARTOOL}
if [ -f ${WAR_FILE} ];
then
	echo "Checking Warranty at " $(date) | tee -a ${LOG}
	${WAR_FILE} ./productVersion.txt
	
	if [ $? -eq 0 ];
	then
		echo "Error to upgrade. Warranty period exceeds !!!" | tee -a ${LOG}
		echo "Ending upgrade script at " $(date) | tee -a ${LOG}
		umount ${DEVICE}
        echo "UERR 1" > /proc/sp4
        do_reboot 1 "Not Allowed"
	fi
fi

    ##### SYSTEM upgrade ###########################
    fl_kupl=0
    flist="`tar -t$TAR_OPT $TAR_FILE`"
    echo "flist:$flist" | tee -a ${LOG}
    # tar -x$TAR_OPT $TAR_FILE $BOOT_NAME $XLDR_NAME
    fl_rfs=`echo $flist | grep -c "$RFS_TAR"`
    fl_kern=`echo $flist | grep -c "$KERN_TAR"`
    fl_boot=`echo $flist | grep -c "$BOOT_TAR"`
    if [[ "${fl_rfs}" -ne "0" && "${fl_kern}" -ne "0" && "${fl_boot}" -ne "0" ]]; then
         tar -x$TAR_OPT $TAR_FILE $NWRITE_NAME
         if [ ! -f $NWRITE_NAME ]; then
            echo "Can not find $NWRITE_NAME. Upgrade cancelled" 
            echo "SMOD 0" > /proc/sp4
            echo "UCMD STRT" > /proc/sp4
            echo "UERR 1" > /proc/sp4
            do_reboot 1 "Error 1.1"
         fi

         tar -xO$TAR_OPT $TAR_FILE $BOOT_TAR | tar -xj
         ls -l | tee -a ${LOG}
         if [ ! -f $NAND_WR ]; then
               echo "$NAND_WR not found" | tee -a ${LOG}
               echo "UERR 1" > /proc/sp4
               do_reboot 1 "Error 1.2"
         fi

         echo "Upgrade BSP" > ${CARD_PATH}/upl_start.log
         if [ ! -f ${CARD_PATH}/upl_start.log ]; then
             echo "SD Readonly" | tee -a ${LOG}
             echo "UERR 1" > /proc/sp4
             do_reboot 1 "Error 1.3"
         fi
    fi
    # RFS
    if [ ! "$fl_rfs" -eq "0" ]; then
         displ "Step 1/9"
         echo "unpack $RFS_NAME to ${CARD_PATH}" | tee -a ${LOG}
         cd ${CARD_PATH}
         tar -xO$TAR_OPT $TAR_FILE $RFS_TAR | tar -xj
         ret=$?
         echo "Unpack ret $ret" | tee -a ${LOG}
         ls -l ${RFS_NAME}* | tee -a ${LOG}
         if [ -f ${RFS_NAME}.md5 ]; then
             hash1=$(cat ${RFS_NAME}.md5)
             echo "Orig hash $hash1" | tee -a ${LOG}
         fi
         if [ $ret -eq 0 ]; then
             hash2=$(md5sum ${RFS_NAME})
             echo "File hash $hash2" | tee -a ${LOG}
             if [ "${hash1}" != "${hash2}" ]; then
                echo "Md5sum error" | tee -a ${LOG}
                ret=1
             fi
         fi
  	     cd ${RAM_PATH}
         if [ ! $ret -eq 0 ]; then
             echo "$RFS_NAME read failure" | tee -a ${LOG}
             echo "UERR 1" > /proc/sp4
             do_reboot 1 "Error 1.4"
         fi
    fi
    # KERN
    if [ ! "$fl_kern" -eq "0" ]; then
         displ "Step 2/9"
         echo "unpack $KERN_NAME to ${CARD_PATH}" | tee -a ${LOG}
         cd ${CARD_PATH}
         tar -xO$TAR_OPT $TAR_FILE $KERN_TAR | tar -xj
         ret=$?
         echo "Unpack ret $ret" | tee -a ${LOG}
         ls -l ${KERN_NAME}* | tee -a ${LOG}
         if [ -f ${KERN_NAME}.md5 ]; then
             cat ${KERN_NAME}.md5 | tee -a ${LOG}
             hash1=$(cat ${KERN_NAME}.md5)
             echo "Orig hash $hash1" | tee -a ${LOG}
         fi
         if [ $ret -eq 0 ]; then
             hash2=$(md5sum ${KERN_NAME})
             echo "File hash $hash2" | tee -a ${LOG}
             if [ "${hash1}" != "${hash2}" ]; then
                echo "Md5sum error" | tee -a ${LOG}
                ret=1
             fi
         fi
		 cd ${RAM_PATH}
         if [ ! $ret -eq 0 ]; then
             echo "$KERN_NAME read failure" | tee -a ${LOG}
             echo "UERR 1" > /proc/sp4
             do_reboot 1 "Error 3"
         fi
    fi
    # BOOT
    if [ ! "$fl_boot" -eq "0" ]; then
         echo "unpack $BOOT_NAME to ${CARD_PATH}" | tee -a ${LOG}
         cd ${CARD_PATH}
         tar -xO$TAR_OPT $TAR_FILE $BOOT_TAR | tar -xj
         ret=$?
         echo "Unpack ret $ret" | tee -a ${LOG}
         ls -l ${BOOT_NAME}* | tee -a ${LOG}
         if [ -f ${BOOT_NAME}.md5 ]; then
             hash1=$(cat ${BOOT_NAME}.md5)
             echo "Orig hash $hash1" | tee -a ${LOG}
         fi
         if [ $ret -eq 0 ]; then
             hash2=$(md5sum ${BOOT_NAME})
             echo "File hash $hash2" | tee -a ${LOG}
             if [ "${hash1}" != "${hash2}" ]; then
                echo "${BOOT_NAME} Md5sum error" | tee -a ${LOG}
                ret=1
             fi
         fi

#         if [ -f $XLDR_NAME ]; then
#           ls -l ${XLDR_NAME}* | tee -a ${LOG}
#           if [ -f ${XLDR_NAME}.md5 ]; then
#               hash1=$(cat ${XLDR_NAME}.md5)
#               echo "Orig hash $hash1" | tee -a ${LOG}
#           fi
#           if [ $ret -eq 0 ]; then
#               hash2=$(md5sum ${XLDR_NAME})
#               echo "File hash $hash2" | tee -a ${LOG}
#               if [ "${hash1}" != "${hash2}" ]; then
#                  echo "${XLDR_NAME} Md5sum error" | tee -a ${LOG}
#                  ret=1
#               fi
#           fi
#         fi

 	     cd ${RAM_PATH}
         fl_kupl=1
    fi

    if [[ "${fl_rfs}" -ne "0" && "${fl_kern}" -ne "0" && "${fl_boot}" -ne "0" ]]; then
         displ "Step 3/9"
         echo "wr $RFS_NAME to $OUT_DD_DEV" | tee -a ${LOG}
         $NAND_WR -d ${OUT_DD_DEV} -o 0x1000000 -i ${CARD_PATH}/${RFS_NAME} | tee -a ${LOG}
         if [ ! $? -eq 0 ]; then
             echo "$RFS_NAME record failure" | tee -a ${LOG}
             flash_erase ${OUT_CHAR_DEV} 0x1000000 | tee -a ${LOG}
             echo "UERR 1" > /proc/sp4
             do_reboot 1 "Error 2"
         fi
         displ "Step 4/9"
         echo "wr $KERN_NAME to $OUT_DD_DEV" | tee -a ${LOG}
         $NAND_WR -d ${OUT_DD_DEV} -o 0x800000 -i ${CARD_PATH}/${KERN_NAME} | tee -a ${LOG}
         if [ ! $? -eq 0 ]; then
             echo "$KERN_NAME record failure" | tee -a ${LOG}
             flash_erase ${OUT_CHAR_DEV} 0x800000 | tee -a ${LOG}
             echo "UERR 1" > /proc/sp4
             do_reboot 1 "Error 4"
         fi
         displ "Step 5/9"
         echo "record BOOT" | tee -a ${LOG}
         if [ -f ${CARD_PATH}/$BOOT_NAME ]; then
           echo "wr $BOOT_NAME to $OUT_DD_DEV" | tee -a ${LOG}
           $NAND_WR -d ${OUT_DD_DEV} -o 0x400000 -i ${CARD_PATH}/${BOOT_NAME} | tee -a ${LOG}
           if [ $? -ne 0 ]; then
               echo "$BOOT_NAME record failure" | tee -a ${LOG}
               flash_erase ${OUT_CHAR_DEV} 0x400000 | tee -a ${LOG}
               echo "UERR 1" > /proc/sp4
               do_reboot 1 "Error 5"
           fi
         fi
         if [ -f $XLDR_NAME ]; then
            echo "x-load-upd set flag" | tee -a ${LOG}
            echo 1 > ${CARD_PATH}/x-load-upd.log
         fi

         echo "$XLDR_NAME copy reset at ${OUT_CHAR_DEV}" | tee -a ${LOG}
         flash_erase ${OUT_CHAR_DEV} 0x0 | tee -a ${LOG}
         fl_kupl=1
    fi

    #
    echo "fl_kupl=$fl_kupl" | tee -a ${LOG}

    #do_sys_check ${BOOT_NAME} 8192
    #do_sys_check ${KERN_NAME} 16384
    #do_sys_check ${RFS_NAME} 32768
    do_sys_check ${BOOT_NAME} 0x400000
    do_sys_check ${KERN_NAME} 0x800000
    do_sys_check ${RFS_NAME} 0x1000000

    if [ "$fl_kupl" -eq "1" ]; then
         echo "UCMD KUPL" > /proc/sp4
      if [ "$smod" -eq "6" ]; then
         echo "SMOD=14"
         echo "SMOD 14" > /proc/sp4
      else
         echo "SMOD 4" > /proc/sp4
         echo "SMOD=4"
      fi
         # The next line fills environment with 0xFF
         # tr "\000" "\377" < /dev/zero | dd count=1024 of=/dev/mtdblock1
         echo "Boot env. reset at /dev/mtd1" | tee -a ${LOG}
         flash_erase /dev/mtd1 cnt 1 | tee -a ${LOG}
         do_reboot 0 "Rebooting"
    fi
fi

##### X-Loader upgrade #####################
if [ -f ${CARD_PATH}/x-load-upd.log ]; then

     rm -f ${CARD_PATH}/x-load-upd.log
     echo "Check $XLDR_NAME u-boot format" | tee -a ${LOG}
     tar -x$TAR_OPT $TAR_FILE $NWRITE_NAME
     new_pattern="12345678.f1000001"
     new_flag=`dd if=${BOOT_DD_DEV} count=1 skip=2048 | head -c 68 | tail -c 8 | hexdump | head -n 1 | awk '{split($0,x," ");printf("%s%s.%s%s",x[3],x[2],x[5],x[4])}'`
     echo "New flag ${new_flag}" | tee -a ${LOG}
                          
     if [ "${new_flag}" != "${new_pattern}" ]; then
       echo "Skip $XLDR_NAME - not found"
       rm -f ${NWRITE_NAME}
     fi

     echo "Check $XLDR_NAME image" | tee -a ${LOG}

         tar -xO$TAR_OPT $TAR_FILE $BOOT_TAR | tar -xj
         ret=$?
         echo "Unpack ret $ret" | tee -a ${LOG}
         if [ -f $XLDR_NAME ]; then
           ls -l ${XLDR_NAME}* | tee -a ${LOG}
           if [ -f ${XLDR_NAME}.md5 ]; then
               hash1=$(cat ${XLDR_NAME}.md5)
               echo "Orig hash $hash1" | tee -a ${LOG}
           fi
           if [ $ret -eq 0 ]; then
               hash2=$(md5sum ${XLDR_NAME})
               echo "File hash $hash2" | tee -a ${LOG}
               if [ "${hash1}" != "${hash2}" ]; then
                  echo "${XLDR_NAME} Md5sum error" | tee -a ${LOG}
                  rm -f ${XLDR_NAME}
                  rm -f ${NWRITE_NAME}
               fi
           fi
         fi

     echo "Check $XLDR_NAME ver" | tee -a ${LOG}
     xldr_ver=`cat x-load.bin.ift.cpu2 | strings | grep -i -a X-Loader | head -n 1 | awk '{split($0,x," ");printf("%s",x[2])}'`
     cur_ver=`grep XLDR /proc/sp4 | awk '{split($0,x," ");printf("%s",x[2])}'`
     echo "xldr_ver:${xldr_ver}" | tee -a ${LOG}
     echo "cur_ver:${cur_ver}" | tee -a ${LOG}
     if [ "$cur_ver" == "$xldr_ver" ]; then
       echo "Skip $XLDR_NAME - the same version ${cur_ver}"
       rm -f ${NWRITE_NAME}
     fi
     if [ -s ${NWRITE_NAME} ]; then
         if [ -f $XLDR_NAME ]; then
           echo "wr $XLDR_NAME to $OUT_DD_DEV" | tee -a ${LOG}
           $NAND_WR -d ${OUT_DD_DEV} -o 0x0 -i ${XLDR_NAME} | tee -a ${LOG}
           if [ $? -ne 0 ]; then
               echo "$XLDR_NAME record failure" | tee -a ${LOG}
               flash_erase ${OUT_CHAR_DEV} 0x0 | tee -a ${LOG}
           else
             echo "UCMD KUPL" > /proc/sp4
             echo "Reboot to update ${XLDR_NAME}" | tee -a ${LOG}
             do_reboot 0 "Rebooting"
           fi
         fi
     fi
fi

echo "$XLDR_NAME copy reset" | tee -a ${LOG}
flash_erase ${OUT_CHAR_DEV} 0x0 | tee -a ${LOG}


##### FW upgrade ###########################

echo "SMOD 0" > /proc/sp4
echo "UCMD STRT" > /proc/sp4

echo "Re-starting upgrade script ${UPGRADE_VER} at " $(date) "smod=$smod" | tee -a ${LOG}

displ "Step 6/9"

mount | tee -a ${LOG}
flist="`tar -t$TAR_OPT $TAR_FILE`"
flist2=`echo ${flist} | sed 's/'${RFS_TAR}'/ /;s/'${KERN_TAR}'/ /'`
#echo "untar $flist2"
tar -xO${TAR_OPT} ${TAR_FILE} ${PMU_TAR} | tar -xj
tar -xO${TAR_OPT} ${TAR_FILE} ${GNSS_TAR} | tar -xj
tar -xO${TAR_OPT} ${TAR_FILE} ${APPL_TAR} | tar -xj

# ServiceMode upgrade
copy_app ${SERVICE_MODE_NAME}
# ServiceLayer upgrade
copy_app ${SERVICE_LAYER_NAME}
copy_app ${PROCESS_LAUNCHER_NAME}
# PVT upgrade
copy_app ${PVT_NAME}
copy_app ${PVT_STORAGE_NAME}

# CPU1 upgrade
SP4LOADER=./${SP4_LOADER_NAME}
CRC32_EXE=./${CRC32_NAME}

CPU1_BOOT_UPGRADE_FILE=./${CPU1_BOOT_NAME}
tar -x$TAR_OPT $TAR_FILE $CRC32_NAME

if [ -f ${CPU1_BOOT_UPGRADE_FILE} ]; then
	if [ -f ${SP4LOADER} ];	then
        displ "Step 7/9"
		echo "Upgrading CPU1 ${CPU1_BOOT_NAME} at " $(date) | tee -a ${LOG}
		ls -l * | tee -a ${LOG}
		rm -rf ./g5.log

        check_gnss ${CPU1_BOOT_NAME}
        check_gnss ${SP4_LOADER_NAME}
   	    if [ -f ${CRC32_EXE} ];	then
			crc=`${CRC32_EXE} ${CPU1_BOOT_UPGRADE_FILE}`
            echo "${CPU1_BOOT_UPGRADE_FILE} crc ${crc}" | tee -a ${LOG}
   		    ${SP4LOADER} -u -f ${CPU1_BOOT_UPGRADE_FILE} -p /dev/ttySP1 -c ${crc} 2>&1
        else
   		    ${SP4LOADER} -u -f ${CPU1_BOOT_UPGRADE_FILE} -p /dev/ttySP1 2>&1
        fi
		if [ ! $? -eq 0 ]; then
			echo "Error to upgrade CPU1 u-boot. Repeat" | tee -a ${LOG}
            echo "=== cpu1_deb.log start ===" | tee -a ${LOG}
	    	cat ./cpu1_deb.log >> ${LOG}
            echo "=== cpu1_deb.log stop ===" | tee -a ${LOG}
   		    ${SP4LOADER} -u -r -f ${CPU1_BOOT_UPGRADE_FILE} -p /dev/ttySP1 2>&1
        fi
		if [ ! $? -eq 0 ]; then
			echo "Error to upgrade CPU1 u-boot !!!" | tee -a ${LOG}
            echo "=== cpu1_deb.log start ===" | tee -a ${LOG}
	    	cat ./cpu1_deb.log >> ${LOG}
            echo "=== cpu1_deb.log stop ===" | tee -a ${LOG}
			echo "Ending upgrade script at " $(date) | tee -a ${LOG}
            do_reboot 1 "Error 7"
		fi
        echo "=== cpu1_deb.log start ===" | tee -a ${LOG}
		cat ./cpu1_deb.log >> ${LOG}
        echo "=== cpu1_deb.log stop ===" | tee -a ${LOG}
	else
		echo "Unable to find tool " ${SP4LOADER} ". Exiting" >> ${LOG} 2>&1
		echo "Ending upgrade script at " $(date) | tee -a ${LOG}
        echo "UERR 1" > /proc/sp4
        do_reboot 1 "Error 7.2"
	fi
fi

if [ -f ${CPU1_XLDR_NAME} ]; then
	if [ -f ${SP4LOADER} ];	then
		echo "Upgrading CPU1 ${CPU1_XLDR_NAME} at " $(date) | tee -a  ${LOG}
		rm -rf ./g5.log

        check_gnss ${CPU1_XLDR_NAME}
        check_gnss ${SP4_LOADER_NAME}
   	    if [ -f ${CRC32_EXE} ]; then
			crc=`${CRC32_EXE} ${CPU1_XLDR_NAME}`
            echo "${CPU1_XLDR_NAME} crc ${crc}" | tee -a ${LOG}
   		    ${SP4LOADER} -x -f ${CPU1_XLDR_NAME} -p /dev/ttySP1 -c ${crc} 2>&1
        else
   		    ${SP4LOADER} -x -f ${CPU1_XLDR_NAME} -p /dev/ttySP1 2>&1
        fi
		if [ ! $? -eq 0 ]; then
			echo "Error to upgrade CPU1 ${CPU1_XLDR_NAME}. Repeat" | tee -a ${LOG}
            echo "=== cpu1_deb.log start ===" | tee -a ${LOG}
	    	cat ./cpu1_deb.log >> ${LOG}
            echo "=== cpu1_deb.log stop ===" | tee -a ${LOG}
   		    ${SP4LOADER} -x -r -f ${CPU1_XLDR_NAME} -p /dev/ttySP1 2>&1
        fi
		if [ ! $? -eq 0 ]; then
			echo "Error to upgrade CPU1 ${CPU1_XLDR_NAME} !!!" | tee -a ${LOG}
		fi
        echo "=== cpu1_deb.log start ===" | tee -a ${LOG}
		cat ./cpu1_deb.log >> ${LOG}
        echo "=== cpu1_deb.log stop ===" | tee -a ${LOG}
	else
		echo "Unable to find tool " ${SP4LOADER} ". Exiting" >> ${LOG} 2>&1
		echo "Ending upgrade script at " $(date) | tee -a ${LOG}
        echo "UERR 1" > /proc/sp4
        do_reboot 1 "Error 7.3"
	fi
fi

G5_UPGRADE_FILE=./${G5_SENSOR_NAME}

if [ -f ${G5_UPGRADE_FILE} ];
then
	if [ -f ${SP4LOADER} ];
	then
        displ "Step 8/9"
        echo "Upgrading G5 at " $(date) | tee -a ${LOG}
		echo "Upgrading G5 sensor" | tee -a ${LOG}
		rm -rf ./g5.log

        check_gnss ${G5_SENSOR_NAME}
        check_gnss ${SP4_LOADER_NAME}

   	    if [ -f ${CRC32_EXE} ];
    	then
			crc=`${CRC32_EXE} ${G5_UPGRADE_FILE}`
            echo "${G5_UPGRADE_FILE} crc ${crc}" | tee -a ${LOG}
		    ${SP4LOADER} -f ${G5_UPGRADE_FILE} -p /dev/ttySP1 -c ${crc} 2>&1
        else
		    ${SP4LOADER} -f ${G5_UPGRADE_FILE} -p /dev/ttySP1 > /dev/null 2>&1
        fi
		if [ ! $? -eq 0 ]; then
			echo "Error to upgrade G5. Repeat" | tee -a ${LOG}
            echo "=== cpu1_deb.log start ===" | tee -a ${LOG}
	    	cat ./cpu1_deb.log >> ${LOG}
            echo "=== cpu1_deb.log stop ===" | tee -a ${LOG}
		    ${SP4LOADER} -r -f ${G5_UPGRADE_FILE} -p /dev/ttySP1 > /dev/null 2>&1
        fi
		if [ ! $? -eq 0 ]; then
			echo "Error to upgrade G5 !!!" | tee -a ${LOG}
            echo "=== cpu1_deb.log start ===" | tee -a ${LOG}
	    	cat ./cpu1_deb.log >> ${LOG}
            echo "=== cpu1_deb.log stop ===" | tee -a ${LOG}
			echo "Ending upgrade script at " $(date) | tee -a ${LOG}
            echo "UERR 1" > /proc/sp4
            do_reboot 1 "Error 8"
		fi
        echo "=== cpu1_deb.log start ===" | tee -a ${LOG}
		cat ./cpu1_deb.log >> ${LOG}
        echo "=== cpu1_deb.log stop ===" | tee -a ${LOG}

	else
		echo "Unable to find tool " ${SP4LOADER} ". Exiting" | tee -a  ${LOG}
		echo "Ending upgrade script at " $(date) | tee -a  ${LOG}
        echo "UERR 1" > /proc/sp4
        do_reboot 1 "Error 8.2"
	fi
fi

CPU1_XLDR_UPGRADE_FILE=./${CPU1_XLDR_NAME}

if [ -f ${CPU1_XLDR_UPGRADE_FILE} ];
then
	if [ -f ${SP4LOADER} ];
	then
		echo "Upgrading CPU1 x-loader at " $(date) | tee -a ${LOG}
		rm -rf ./g5.log

        check_gnss ${CPU1_XLDR_NAME}
        check_gnss ${SP4_LOADER_NAME}

		${SP4LOADER} -x -f ${CPU1_XLDR_UPGRADE_FILE} -p /dev/ttySP1 >> ./g5.log 2>&1
		if [ ! $? -eq 0 ];
		then
            displ "Error 8.3"
			echo "Error to upgrade CPU1 x-loader !!!" | tee -a ${LOG}
			cat ./g5.log >> ${LOG}
			echo "Ending upgrade script at " $(date) | tee -a ${LOG}
            # sleep 1
			# exit 5
		fi
	else
		echo "Unable to find tool " ${SP4LOADER} ". Exiting" | tee -a ${LOG}
		echo "Ending upgrade script at " $(date) | tee -a ${LOG}
        echo "UERR 1" > /proc/sp4
        do_reboot 1 "Error 8.4"
	fi
fi

# PMU upgrade
PMU_UPGRADE_FILE=./${PMU_FW_NAME}
PMU_LOADER=./${PMU_LOADER_NAME}

if [ -f ${PMU_UPGRADE_FILE} ];
then
	if [ -f ${PMU_LOADER} ];
	then
        displ "Step 9/9"
		echo "Upgrading PMU at " $(date) | tee -a  ${LOG}

        check_pmu ${PMU_FW_NAME}
        check_pmu ${PMU_LOADER_NAME}

		rm -rf ./pmu.log
		${PMU_LOADER} -s 80000 -f ${PMU_UPGRADE_FILE} -p /dev/spidev3.0 >> ./pmu.log 2>&1
		if [ ! $? -eq 0 ];
		then
			${PMU_LOADER} -s 80000 -i -f ${PMU_UPGRADE_FILE} -p /dev/spidev3.0 >> ./pmu.log 2>&1
			if [ ! $? -eq 0 ];
			then
				echo "Error to upgrade PMU !!!" | tee -a  ${LOG}
				cat ./pmu.log | tee -a  ${LOG}
				echo "Ending upgrade script at " $(date) | tee -a ${LOG}
                echo "UERR 1" > /proc/sp4
                do_reboot 1 "Error 9.2"
			fi
		fi
	else
		echo "Unable to find tool " ${PMU_LOADER} ". Exiting" | tee -a ${LOG}
		echo "Ending upgrade script at " $(date) >> ${LOG}
        echo "UERR 1" > /proc/sp4
        do_reboot 1 "Error 9.3"
	fi
fi

cd ${BIN_PATH}
tar -x${TAR_OPT} ${TAR_FILE} productVersion.txt
new_ver=$(cat productVersion.txt)

cd ${RAM_PATH}
echo "Product version ${new_ver}"  | tee -a ${LOG}
echo "End upgrade script at " $(date) | tee -a ${LOG}
echo "Exit code is 0" | tee -a ${LOG}
# 
# Terminate the script with success return code.
#
exit 0
