#!/bin/sh
#set -xv
UPGRADE_VER="0.0.7"
BIN_PATH="/home/root"
CARD_PATH=${MOUNTR}
UPGRADE_MD5="upgrade.md5"
UPGRADE_SH="Upgrade.sh"
KERN_NAME="uImage-blaze"
BOOT_NAME="u-boot.imx"
RTFS_NAME="blaze_rootfs"
NWRITE_NAME="nwrite"
NAND_WR=${CARD_PATH}/${NWRITE_NAME}
WARTOOL="checkWar"
PROD_NAME="productVersion.txt"
# NAND
BOOT_DD_DEV=/dev/mtdblock1
KERN_DD_DEV=/dev/mtdblock4
RTFS_DD_DEV=/dev/mtdblock5
RESC_DD_DEV=/dev/mtdblock7
RESC_BOOT_OFS=0x100000
RESC_KERN_OFS=0x200000
RESC_RTFS_OFS=0xA00000
DIAG_DD_DEV=/dev/mtdblock8

do_reboot() {
#  if [ -f ${CARD_PATH}/upl_start.log ]; then
    echo "Removing temporary files from ${CARD_PATH}" | tee -a ${LOG}
    rm -f ${CARD_PATH}/${RTFS_NAME}* ${CARD_PATH}/${KERN_NAME}* ${CARD_PATH}/${BOOT_NAME}* ${CARD_PATH}/upl_start.log
    rm -f ${CARD_PATH}/${UPGRADE_MD5} ${CARD_PATH}/${NWRITE_NAME} ${CARD_PATH}/${PROD_NAME}
    rm -f ${CARD_PATH}/*.ta_
    rm -f ${CARD_PATH}/${UPGRADE_SH}
#  fi
  echo "Message:${2}" | tee -a ${LOG}
  # !The next should be the lats message in uploading.log!
  echo "Exit code is ${1}" | tee -a ${LOG}
  reboot
  sleep 300
}

do_file_check() {
 echo "[$(cat /proc/uptime | cut -d ' ' -f1)] Check file ${1}" | tee -a ${LOG}
 hash1=`grep ${1} ${UPGRADE_MD5} | awk '{split($0,x," ");printf("%s",x[1])}'`
 echo "Orig hash $hash1" | tee -a ${LOG}
 hash2=$(md5sum ${1} | awk '{split($0,x," ");printf("%s",x[1])}')
 echo "File hash $hash2" | tee -a ${LOG}
 if [ "${hash1}" != "${hash2}" ]; then
  echo "${1} read failure" | tee -a ${LOG}
  echo "SMOD 0" > /proc/sp4
  echo "UCMD STRT" > /proc/sp4
  echo "UERR 1" > /proc/sp4
  do_reboot -1 "Error 3"
 fi
}

do_sys_check() {
 chk_name=${CARD_PATH}/${1}
 chk_len=$(ls -l $chk_name | awk '{split($0,x," ");printf("%s",x[5])}')
 dd_len=$(($chk_len/512+1))
 chk_hash="n/a"
 $NAND_WR -d ${3} -o $2 -r ${chk_name}.out ${chk_len} | tee -a ${LOG}
 if [ $? -eq 0 ]; then
  chk_hash=`cat ${chk_name}.out | md5sum | awk '{split($0,x," ");printf("%s",x[1])}'`
 else
  echo "$NAND_WR read error" | tee -a ${LOG}
  chk_hash="n/a"  
 fi
 orig_hash=`grep ${1} ${CARD_PATH}/${UPGRADE_MD5} | awk '{split($0,x," ");printf("%s",x[1])}'`
 echo "chk_name $chk_name chk_len $chk_len dd_len $dd_len skip $2" | tee -a ${LOG}
 echo "chk_hash  $chk_hash" | tee -a ${LOG}
 echo "orig_hash $orig_hash" | tee -a ${LOG}
 if [ "${chk_hash}" != "${orig_hash}" ]; then
  echo "[$(cat /proc/uptime | cut -d ' ' -f1)] ${1} md5sum differ" | tee -a ${LOG}
  ret=1
 else 
  echo "[$(cat /proc/uptime | cut -d ' ' -f1)] ${1} md5sum Ok" | tee -a ${LOG}
  ret=0
 fi
}

do_sys_write() {
 # Img.Name, Offs, Dev.Name
 /usr/local/bin/wd_ping -1 > /dev/null
 do_sys_check $1 $2 $3
 if [ $ret -ne 0 ]; then
  echo "[$(cat /proc/uptime | cut -d ' ' -f1)] wr img:${1} to dev:${3} offs:${2}" | tee -a ${LOG}
  /usr/local/bin/wd_ping -1 > /dev/null
  $NAND_WR -d ${3} -o ${2} -i ${CARD_PATH}/${1} | tee -a ${LOG}
  if [ $? -ne 0 ]; then
	echo "[$(cat /proc/uptime | cut -d ' ' -f1)] ${1} record failure" | tee -a ${LOG}
	ret=1
  else
    echo "[$(cat /proc/uptime | cut -d ' ' -f1)] img:${1} on dev:${3} offs:${2} write Ok" | tee -a ${LOG}
    ret=0
  fi
 else
  echo "[$(cat /proc/uptime | cut -d ' ' -f1)] img:${1} on dev:${3} offs:${2} is the same. Write skipped" | tee -a ${LOG}
 fi
}

# start from here
cd ${CARD_PATH}
rm -f ${LOG}
echo "[$(cat /proc/uptime | cut -d ' ' -f1)] Starting upgrade script ${UPGRADE_VER} at " $(date) "smod=$smod" | tee -a ${LOG}
ps | grep wd_ping | awk '{split($0,x," ");printf("%s ",x[1])}' | xargs kill
sleep 1
/usr/local/bin/wd_ping -60 -p | tee -a ${LOG} &
ret=$?
echo "wd_ping ret $ret" | tee -a ${LOG}
if [ $ret -ne 0 ]; then
/usr/local/bin/wd_ping -60 -p | tee -a ${LOG} &
fi
uname -a | tee -a ${LOG}
mount | tee -a ${LOG}
ps | grep wd_ping | tee -a ${LOG}
df | tee -a ${LOG}
if [ -f ${BIN_PATH}/${PROD_NAME} ]; then
   echo "Previous product version " $(cat ${BIN_PATH}/${PROD_NAME}) | tee -a ${LOG}
fi

# Check Warr
pwd | tee -a ${LOG}
tar -x${TAR_OPT} ${TAR_FILE} ${PROD_NAME}
ls -l * | tee -a ${LOG}

if [ ! "$(cat ${BIN_PATH}/${PROD_NAME} | awk '{split($0,x,"_");printf("%s",x[2])}')" == "rescue" ]; then
WAR_FILE=${BIN_PATH}/${WARTOOL}
 if [ -f ${WAR_FILE} ]; then
 echo "Checking Warr at " $(date) | tee -a ${LOG}
 ${WAR_FILE} ./${PROD_NAME}
 if [ $? -eq 0 ]; then
  echo "Error to upgrade. Warranty period exceeds !!!" | tee -a ${LOG}
  echo "Ending upgrade script at " $(date) | tee -a ${LOG}
  echo "SMOD 0" > /proc/sp4
  echo "UCMD STRT" > /proc/sp4
  echo "UERR 1" > /proc/sp4
  do_reboot -1 "Not Allowed"
 fi
fi
else
 echo "Rescue mode. Skip Warr"
fi

fl_kupl=0
/usr/local/bin/blaze_leds on FF
flist="`tar -t$TAR_OPT $TAR_FILE`"
echo "flist:$flist" | tee -a ${LOG}
fl_rfs=`echo $flist | grep -c "$RTFS_NAME"`
fl_kern=`echo $flist | grep -c "$KERN_NAME"`
fl_boot=`echo $flist | grep -c "$BOOT_NAME"`
echo "fl_rfs=$fl_rfs, fl_kern=$fl_kern, fl_boot=$fl_boot" | tee -a ${LOG}
if [[ "${fl_rfs}" -ne "0" && "${fl_kern}" -ne "0" && "${fl_boot}" -ne "0" ]]; then
     fl_kupl=1
     tar -x$TAR_OPT $TAR_FILE $UPGRADE_MD5
     if [ ! -f ${UPGRADE_MD5} ]; then
        echo "Can not find $UPGRADE_MD5. Upgrade cancelled" | tee -a ${LOG}
        echo "SMOD 0" > /proc/sp4
        echo "UCMD STRT" > /proc/sp4
        echo "UERR 1" > /proc/sp4
        do_reboot -1 "Error 1.1"
     fi
     tar -x$TAR_OPT $TAR_FILE $NWRITE_NAME
     if [ ! -f ${NWRITE_NAME} ]; then
        echo "Can not find $NWRITE_NAME. Upgrade cancelled" | tee -a ${LOG}
        echo "SMOD 0" > /proc/sp4
        echo "UCMD STRT" > /proc/sp4
        echo "UERR 1" > /proc/sp4
        do_reboot -1 "Error 1.2"
     fi
     do_file_check ${NWRITE_NAME}
     echo "Upgrade BSP" > ${CARD_PATH}/upl_start.log
     if [ ! -f ${CARD_PATH}/upl_start.log ]; then
         echo "Readonly" | tee -a ${LOG}
         echo "SMOD 0" > /proc/sp4
         echo "UCMD STRT" > /proc/sp4
         echo "UERR 1" > /proc/sp4
         do_reboot -1 "Error 1.3"
     fi
fi
# RFS
if [ ! "$fl_rfs" -eq "0" ]; then
     echo "unpack $RTFS_NAME to ${CARD_PATH}" | tee -a ${LOG}
     tar -x$TAR_OPT $TAR_FILE $RTFS_NAME
     ret=$?
     echo "Unpack ret $ret" | tee -a ${LOG}
     do_file_check ${RTFS_NAME}
fi
# KERN
if [ ! "$fl_kern" -eq "0" ]; then
     echo "unpack $KERN_NAME to ${CARD_PATH}" | tee -a ${LOG}
     tar -x$TAR_OPT $TAR_FILE $KERN_NAME
     ret=$?
     echo "Unpack ret $ret" | tee -a ${LOG}
     do_file_check ${KERN_NAME}
fi
# BOOT
if [ ! "$fl_boot" -eq "0" ]; then
     echo "unpack $BOOT_NAME to ${CARD_PATH}" | tee -a ${LOG}
     tar -x$TAR_OPT $TAR_FILE $BOOT_NAME | tar -xj
     ret=$?
     echo "Unpack ret $ret" | tee -a ${LOG}
     do_file_check ${BOOT_NAME}
fi

if [ "${fl_kupl}" -ne "1" ]; then
  do_reboot -1 "Update skipped. Exiting"
fi

# Resc
echo "[$(cat /proc/uptime | cut -d ' ' -f1)] Write rescue" | tee -a ${LOG}
do_sys_write ${BOOT_NAME} $RESC_BOOT_OFS $RESC_DD_DEV
echo "ret $ret" | tee -a ${LOG}
do_sys_write ${KERN_NAME} $RESC_KERN_OFS $RESC_DD_DEV
echo "ret $ret" | tee -a ${LOG}
do_sys_write ${RTFS_NAME} $RESC_RTFS_OFS $RESC_DD_DEV
echo "ret $ret" | tee -a ${LOG}

# Main
echo "[$(cat /proc/uptime | cut -d ' ' -f1)] Write main" | tee -a ${LOG}
do_sys_write ${BOOT_NAME} 0 $BOOT_DD_DEV
echo "ret $ret" | tee -a ${LOG}
do_sys_write ${KERN_NAME} 0 $KERN_DD_DEV
echo "ret $ret" | tee -a ${LOG}
do_sys_write ${RTFS_NAME} 0 $RTFS_DD_DEV
echo "ret $ret" | tee -a ${LOG}

if [ "$fl_kupl" -eq "1" ]; then
     echo "UCMD KUPL" > /proc/sp4
     # The next line fills environment with 0xFF
     # tr "\000" "\377" < /dev/zero | dd count=1024 of=/dev/mtdblock1
     echo "Boot env. reset at /dev/mtd2" | tee -a ${LOG}
     flash_erase /dev/mtd2 cnt 1 | tee -a ${LOG}
fi

echo "Removing prev.data" | tee -a ${LOG}
rm -rf /mnt/pvt/reg* /mnt/pvt/antenna/
cd /mnt/bin
rm -f CHAN PVT SL sp4*.sh bt_iap pvt_storage.txt productVersion.txt processLauncher
rm -rf www
sync
echo "[$(cat /proc/uptime | cut -d ' ' -f1)] Removing prev.data complete" | tee -a ${LOG}

echo "SMOD 0" > /proc/sp4
echo "UCMD STRT" > /proc/sp4
do_reboot 0 "Complete"
